# Поликультура
Возможно, ты уже знаешь, что растения иногда приносят больше урожая, если их сажают вместе с другими видами.
Трава, кусты, деревья и морковь приносят больше урожая, когда у них есть правильный компаньон. Желаемый компаньон у каждого растения свой, и его предпочтения невозможно предсказать. К счастью, предпочтения растения под дроном можно измерить с помощью функции `get_companion()`. Она возвращает кортеж, где первый элемент — тип желаемого растения-компаньона, а второй — позиция, где его нужно посадить.

`plant_type, (x, y) = get_companion()`

Например, если посадить куст, а затем вызвать `get_companion()`, функция вернет что-то вроде `(Entities.Carrot, (3, 5))`. То есть куст хочет, чтобы морковь росла на позиции `(3,5)`. Если ты посадишь морковь на `(3,5)`, то при сборе урожая с куста получишь больше древесины. Стадия роста моркови значения не имеет.

Растение может хотеть в качестве компаньона `Entities.Grass`, `Entities.Bush`, `Entities.Tree` либо `Entities.Carrot`. Значение выбирается случайным образом, но компаньон всегда отличается от растения по типу. Позиция также может быть любой в пределах трех ходов от растения, не включая позицию самого растения.

Если под дроном нет растения, у которого есть желаемый компаньон, `get_companion()` вернет `None`.

До разблокировки поликультуры множитель урожая равен `5`. С каждым улучшением он удваивается.